############################################################################
#####################        function define     ###########################
############################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

############################################################################
#########################      read in data       ##########################
############################################################################

methyratio_promoter <- read.table("../data/2nd_average_methratio_on_promoter.txt",header=T,row.names=1)
hiFT <- methyratio_promoter[,"hiFT"]
he6 <- methyratio_promoter[,"he6"]
n12 <- apply(methyratio_promoter[,c("n12","n12_r2")],1,mean)
n20 <- methyratio_promoter[,"n20"]
n24 <- methyratio_promoter[,"n24"]
niPS <- methyratio_promoter[,"niPS"]
p20 <- apply(methyratio_promoter[,c("p20","p20_r2")],1,mean)
p24 <- apply(methyratio_promoter[,c("p24","p24_r2")],1,mean)
piPS <- methyratio_promoter[,"piPS"]
ICM <- apply(methyratio_promoter[,c("ICM1_r1","ICM1_r2","ICM2","ICM3")],1,mean)

methyratio_promoter_average <- cbind(hiFT,he6,n20,n24,niPS,p20,p24,piPS,ICM)
n_time_points <- c("hiFT","he6","n12","n20","n24","niPS")
labels <- c("hiFT-C","6d","n12","20d","24d","iPSC-T")

############################################################################
####################               plot            #########################
############################################################################

selected_gene <- c("ALPL","ALPPL2","FGF4","LEFTY1","DPPA2","DPPA3","DPPA5","MBD3L2","NLRP2","TDGF1","TET2","ZNF57","ZNF534","TERT","ATP13A1","ATP1B1","ATP2B2","ATP2B3","ATP2B4","ATP4B","ATP5A1","ATP5D","ATP5G1","ATP5I","ATP5J2")
pdf("Fig5E.pdf",width=8,height=2.5)
plot_data_n <- t(methyratio_promoter[selected_gene,n_time_points])
par(mar=c(5,4,2,1))
layout(matrix(c(rep(1,10),2),nrow=1,ncol=11,byrow=T))
all_exp <- c(as.matrix(plot_data_n),as.matrix(plot_data_n)) # using same scale bar
zmax <- 1
zmin <- 0
ColorRamp <- colorRampPalette(c("white","#F2FAB0","red"), bias=1)(1000)   #color list
plotMatrix <- plot_data_n
plotMatrix[plotMatrix<zmin] <- zmin
plotMatrix[plotMatrix>zmax] <- zmax
ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="naive",ylab="")
axis(side=2,1:nrow(plotMatrix),labels=rev(n_time_points),las=2)
axis(side=1,1:ncol(plotMatrix),labels=colnames(plotMatrix),las=2)
par(mar=c(5,1,2,4))
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)),las=2)
dev.off()

selected_gene <- c("ALPL","ALPPL2","FGF4","LEFTY1","DPPA2","DPPA3","DPPA5","MBD3L2","NLRP2","TDGF1","TET2","ZNF57","ZNF534","TERT")
pdf("Fig5E_1.pdf",width=5,height=2.5)
plot_data_n <- t(methyratio_promoter[selected_gene,n_time_points])
par(mar=c(5,4,2,1))
layout(matrix(c(rep(1,6),2),nrow=1,ncol=7,byrow=T))
all_exp <- c(as.matrix(plot_data_n),as.matrix(plot_data_n)) # using same scale bar
zmax <- 1
zmin <- 0
ColorRamp <- colorRampPalette(c("white","#F2FAB0","red"), bias=1)(1000)   #color list
plotMatrix <- plot_data_n
plotMatrix[plotMatrix<zmin] <- zmin
plotMatrix[plotMatrix>zmax] <- zmax
ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="naive",ylab="")
axis(side=2,1:nrow(plotMatrix),labels=rev(n_time_points),las=2)
axis(side=1,1:ncol(plotMatrix),labels=colnames(plotMatrix),las=2)
par(mar=c(5,1,2,4))
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)),las=2)
dev.off()
